//								KBD2.c
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
// Funciones para la gestin del teclado de la Trainer PLUS.

// char kbd_getc()	Devuelve el cdigo ASCII de la tecla pulsada.
//					Si no se puls ninguna, devuelve 0.


// Conexiones del teclado.
/* 
            RB0 RB1 RB2 RB3
             ^   ^   ^   ^
             |   |   |   |
           |---|---|---|---|
  RB4 ---> | 1 | 2 | 3 | A |
           |---|---|---|---|
  RB5 ---> | 4 | 5 | 6 | B |
           |---|---|---|---|
  RB6 ---> | 7 | 8 | 9 | C |
           |---|---|---|---|
  RB7 ---> | F | 0 | E | D |
           |---|---|---|---|
*/

// Caracteres ASCII asociados a cada tecla:
char const KEYS[4][4] = {{'1','2','3','A'},
                         {'4','5','6','B'},
                         {'7','8','9','C'},
                         {'F','0','E','D'}};

#byte kbd_port_b = 6


char kbd_getc()
{
	int temporal;
	char tecla=0;
  	int f,c,t,i,j;

//Salva el contenido actual del registro TRISB	
	#asm
	bsf 	0x3,0x5
	movf	0x06,w
	bcf		0x3, 0x5
	movwf	temporal
	#endasm

 	port_b_pullups(true);
  	set_tris_b(0b00001111); // RB7-RB4 salidas, RB3-RB0 entradas

//Exploracin del teclado

  for(f=0x10, i=0; i<4; f<<=1, i++)
  {
    for(c=0x01, j=0; j<4; c<<=1, j++)
    {
      kbd_port_b = ~f;
      delay_cycles(1);
      t = kbd_port_b & 0x0f;
      t = ~(t | 0xf0);
      if(t == c)
      {
        delay_ms(20);
        tecla=KEYS[i][j];
        while(t==c)
        {
          t = kbd_port_b & 0x0f;
          t = ~(t | 0xf0);
        }
        break;
      }
    }
    if(tecla)
      break;
  }

  port_b_pullups(false);

//Recupera el valor de TRISB con lo que la puerta B queda como estaba
	#asm
	bcf 	0x3,0x5
	movf	temporal,w
	bsf		0x3, 0x5
	movwf	0x06
	bcf		0x3,0x5
	#endasm

  return tecla;
}
